/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.computer;

import java.util.List;
import org.jspecify.annotations.Nullable;

public enum ComputerSide {
    BOTTOM("bottom"),
    TOP("top"),
    BACK("back"),
    FRONT("front"),
    RIGHT("right"),
    LEFT("left");

    public static final List<String> NAMES;
    public static final int COUNT = 6;
    private static final ComputerSide[] VALUES;
    private final String name;

    private ComputerSide(String name) {
        this.name = name;
    }

    public static ComputerSide valueOf(int side) {
        return VALUES[side];
    }

    public static @Nullable ComputerSide valueOfInsensitive(String name) {
        for (ComputerSide side : VALUES) {
            if (!side.name.equalsIgnoreCase(name)) continue;
            return side;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    static {
        NAMES = List.of("bottom", "top", "back", "front", "right", "left");
        VALUES = ComputerSide.values();
    }
}

